// ViewFilterEditor
// this dialog box will show the content and location of a filter

var g_ViewFilterId = 0;

function ViewFilterEditor(eid, sPath)
{
	this.path = sPath;
	this.frame = document.getElementById(eid + 'Frame');
	if (this.frame == null)
	{
      this.frame = saw.createHiddenIFrame("idFilterViewFrame", "idFilterViewFrame");
	}

	++g_ViewFilterId;
	var tId = 'ViewFilterId' + g_ViewFilterId;
	this.id = tId;
	var tDiv = document.getElementById(tId + 'Div');

	if (tDiv == null)
	{
		tDiv = document.getElementById(eid + 'Div').cloneNode(true);
		tDiv.id = tId + 'Div';

		var tTr = tDiv.getElementsByTagName('tr');
		var tTitleBar;
		for(i=0; i<tTr.length; i++)
		{
			if(tTr[i].id.toLowerCase() == 'titlebar')
			{
				tTitleBar = tTr[i];
				tTitleBar.onmouseover=function() { setHot(tDiv.id); }
				break;
			}
		}

		var aButtons = tDiv.getElementsByTagName('a');
		var button;
		for(i = 0; i < aButtons.length; i++)
		{
			if(aButtons[i].id == eid + 'Button')
			{
				button = aButtons[i];
				break;
			}
		}
		button.id = tId + 'Button';
		button.setAttribute("eid", tId);
		saw.addEventListener(button, "click", ViewFilterEditor.close);
		document.body.appendChild(tDiv);
	}

	// get the location Div
	var aDivs = tDiv.getElementsByTagName("div");
	for(i = 0; i < aDivs.length ; i++)
	{
		if(aDivs[i].id == eid + 'Location')
			this.locationDiv = aDivs[i];
	}
	// TODO: get rid of the html table as this html will be produced by the server
	var aTables = tDiv.getElementsByTagName("table");
	for(i = 0; i < aTables.length; i++)
	{
		if(aTables[i].id == eid + 'Table')
			this.htmlTable = aTables[i];
	}
	this.div = tDiv;
	this.panel = new XUIInline(tId,this,null);
}

ViewFilterEditor.prototype = new XUIEditor();

ViewFilterEditor.prototype.load = function(xmlElement)
{
	this.filter = xmlElement.selectSingleNode("//saw:filter");
	this.expr = this.filter.firstChild;

	this.showFilters();
}

// TODO: make those functions static in the FilterEditor. they are referenced here in
// in the ApplyFilterEditor and the FilterEditor.

ViewFilterEditor.prototype.showFilters = function()
{
	this.locationDiv.innerHTML = this.filterLocation;

	this.clearHTMLTable();

	if(this.filter.hasChildNodes())
	{
		var tr = this.htmlTable.insertRow(this.htmlTable.rows.length);
		FilterEditor.addCellsForExpr(this.expr,tr,false);
	}
}

ViewFilterEditor.prototype.clearHTMLTable = function()
{
	while (this.htmlTable.rows.length > 0)
		this.htmlTable.deleteRow(-1);
}

ViewFilterEditor.prototype.loadSavedFilter = function(x,y)
{
	var sUrl = saw.commandToURL("LoadSavedFilter") + "&FilterPath=" + saw.encodeURIComponent(this.path);
	sUrl += "&Action=ViewFilter";
	sUrl += "&ClientX=" + x;
	sUrl += "&ClientY=" + y;
	sUrl += "&Id=" + this.id;

	this.frame.src = sUrl;

	return true;
}

ViewFilterEditor.displayFilters = function(eid,sPath,x,y)
{
	var tEditor = XUIPanel.getEditor(sPath);
	var tFrame = window.frames[eid + 'Frame'];
	var tForm = tFrame.document.forms[eid + 'Form'];

	tEditor.filterLocation = tForm.Location.value;

   var tRootXML = XUIGetRootXML(null, tFrame);

	// add the filter caption to the caption catalog space
	var tCatalogCaptionSpace = tRootXML.selectSingleNode('//saw:catalogCaptionSpace');
	XUICatalogCaptionSpace.add(tCatalogCaptionSpace);

   var tColumnSpace = tRootXML.selectSingleNode('//saw:columnSpace');
   if (tColumnSpace)
      XUIColumnSpace.setColumnSpaceElement(tColumnSpace);
	var tDialog = new XUIDialog(sPath,tEditor,null);

	tDialog.show(tRootXML,x,y);
}

ViewFilterEditor.close = function(event)
{
   var eid = saw.getEventTarget(event).getAttribute("eid");
	XUIDialog.cancel(eid);
}

ViewFilterEditor.onViewFromFiltersView = function (eid, sPath, event)
{
   var tEditor = XUIPanel.getEditor(eid);

   ColumnFilterEditor.initializeOperatorList();
   var tViewFilterEditor = new ViewFilterEditor('idFilterView', sPath);
   tViewFilterEditor.loadSavedFilter(20, event.clientY);
}




